-- stat area; per-player
local Player = ...
assert(Player,"StatArea needs Player")

local fallbackPaneValue = "...."
local gradeChild

return Def.ActorFrame{
	InitCommand=cmd(player,Player);
	PlayerJoinedMessageCommand=function(self, params)
		if params.Player == Player then self:visible(true) end;
	end;
	PlayerUnjoinedMessageCommand=function(self, params)
		if params.Player == Player then self:visible(false) end;
	end;

	Def.ActorFrame{
		Name="PaneishDisplay";

		-- column 1
		Def.ActorFrame{
			Name="Column1";
			InitCommand=cmd(x,-128);

			LoadFont("_smallcaps 8px")..{
				Name="Notes";
				InitCommand=cmd(halign,0;y,-16;shadowlength,1;diffuse,RadarCategoryColors['TapsAndHolds'].Main);
				OnCommand=cmd(diffusealpha,0;sleep,0.75;linear,0.25;diffusealpha,1);
				SetCommand=function(self)
					local mainText = THEME:GetString("PaneishDisplay",self:GetName())
					local songCourse = SongOrCourse()
					local stepsTrail = StepsOrTrail(Player)
					local rv
					local val = fallbackPaneValue
					if songCourse then
						if stepsTrail then
							local rv = stepsTrail:GetRadarValues(Player)
							val = rv:GetValue('RadarCategory_TapsAndHolds')
							if val == -1 then val = "?" end
						else
							val = fallbackPaneValue
						end
					else
						val = fallbackPaneValue
					end
					self:settext(mainText.." "..val)
				end;
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
				CurrentStepsP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
				CurrentTrailP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
				CurrentStepsP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;
				CurrentTrailP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;
			};
			LoadFont("_smallcaps 8px")..{
				Name="Jumps";
				InitCommand=cmd(halign,0;y,-7;shadowlength,1;diffuse,RadarCategoryColors['Jumps'].Main);
				OnCommand=cmd(diffusealpha,0;sleep,0.75;linear,0.25;diffusealpha,1);
				SetCommand=function(self)
					local mainText = THEME:GetString("PaneishDisplay",self:GetName())
					local songCourse = SongOrCourse()
					local stepsTrail = StepsOrTrail(Player)
					local rv
					local val = fallbackPaneValue
					if songCourse then
						if stepsTrail then
							local rv = stepsTrail:GetRadarValues(Player)
							val = rv:GetValue('RadarCategory_Jumps')
							if val == -1 then val = "?" end
						else
							val = fallbackPaneValue
						end
					else
						val = fallbackPaneValue
					end
					self:settext(mainText.." "..val)
				end;
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
				CurrentStepsP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
				CurrentTrailP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
				CurrentStepsP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;
				CurrentTrailP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;
			};
			LoadFont("_smallcaps 8px")..{
				Name="Holds";
				InitCommand=cmd(halign,0;y,2;shadowlength,1;diffuse,RadarCategoryColors['Holds'].Main);
				OnCommand=cmd(diffusealpha,0;sleep,0.75;linear,0.25;diffusealpha,1);
				SetCommand=function(self)
					local mainText = THEME:GetString("PaneishDisplay",self:GetName())
					local songCourse = SongOrCourse()
					local stepsTrail = StepsOrTrail(Player)
					local rv
					local val = fallbackPaneValue
					if songCourse then
						if stepsTrail then
							local rv = stepsTrail:GetRadarValues(Player)
							val = rv:GetValue('RadarCategory_Holds')
							if val == -1 then val = "?" end
						else
							val = fallbackPaneValue
						end
					else
						val = fallbackPaneValue
					end
					self:settext(mainText.." "..val)
				end;
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
				CurrentStepsP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
				CurrentTrailP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
				CurrentStepsP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;
				CurrentTrailP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;
			};
		};
		-- column 2
		Def.ActorFrame{
			Name="Column2";
			InitCommand=cmd(x,-24;);

			LoadFont("_smallcaps 8px")..{
				Name="Rolls";
				InitCommand=cmd(halign,0;y,-16;shadowlength,1;diffuse,RadarCategoryColors['Rolls'].Main);
				OnCommand=cmd(diffusealpha,0;sleep,0.75;linear,0.25;diffusealpha,1);
				SetCommand=function(self)
					local mainText = THEME:GetString("PaneishDisplay",self:GetName())
					local songCourse = SongOrCourse()
					local stepsTrail = StepsOrTrail(Player)
					local rv
					local val = fallbackPaneValue
					if songCourse then
						if stepsTrail then
							local rv = stepsTrail:GetRadarValues(Player)
							val = rv:GetValue('RadarCategory_Rolls')
							if val == -1 then val = "?" end
						else
							val = fallbackPaneValue
						end
					else
						val = fallbackPaneValue
					end
					self:settext(mainText.." "..val)
				end;
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
				CurrentStepsP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
				CurrentTrailP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
				CurrentStepsP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;
				CurrentTrailP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;
			};
			LoadFont("_smallcaps 8px")..{
				Name="Hands";
				InitCommand=cmd(halign,0;y,-7;shadowlength,1;diffuse,RadarCategoryColors['Hands'].Main);
				OnCommand=cmd(diffusealpha,0;sleep,0.75;linear,0.25;diffusealpha,1);
				SetCommand=function(self)
					local mainText = THEME:GetString("PaneishDisplay",self:GetName())
					local songCourse = SongOrCourse()
					local stepsTrail = StepsOrTrail(Player)
					local rv
					local val = fallbackPaneValue
					if songCourse then
						if stepsTrail then
							local rv = stepsTrail:GetRadarValues(Player)
							val = rv:GetValue('RadarCategory_Hands')
							if val == -1 then val = "?" end
						else
							val = fallbackPaneValue
						end
					else
						val = fallbackPaneValue
					end
					self:settext(mainText.." "..val)
				end;
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
				CurrentStepsP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
				CurrentTrailP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
				CurrentStepsP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;
				CurrentTrailP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;
			};
			LoadFont("_smallcaps 8px")..{
				Name="Mines";
				InitCommand=cmd(halign,0;y,2;shadowlength,1;diffuse,RadarCategoryColors['Mines'].Main);
				OnCommand=cmd(diffusealpha,0;sleep,0.75;linear,0.25;diffusealpha,1);
				SetCommand=function(self)
					local mainText = THEME:GetString("PaneishDisplay",self:GetName())
					local songCourse = SongOrCourse()
					local stepsTrail = StepsOrTrail(Player)
					local rv
					local val = fallbackPaneValue
					if songCourse then
						if stepsTrail then
							local rv = stepsTrail:GetRadarValues(Player)
							val = rv:GetValue('RadarCategory_Mines')
							if val == -1 then val = "?" end
						else
							val = fallbackPaneValue
						end
					else
						val = fallbackPaneValue
					end
					self:settext(mainText.." "..val)
				end;
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
				CurrentStepsP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
				CurrentTrailP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
				CurrentStepsP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;
				CurrentTrailP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;
			};
		};
	};

	Def.ActorFrame{
		Name="GradeDisplay";
		InitCommand=function(self)
			gradeChild = self:GetChildren()
			self:x(106)
		end;
		SetCommand=function(self)
			-- do things, ok?
			local course = SongOrCourse()
			local trail,profile,scorelist,grade,score
			local isMachine = false
			if course then
				gradeChild.GradeIcon:visible(true)
				trail = StepsOrTrail(Player)
				if trail then
					profile = GetPlayerProfile(Player)
					if profile then
						scorelist = profile:GetHighScoreList(course,trail);
						assert(scorelist);
						local scores = scorelist:GetHighScores();
						local topscore = scores[1];
						grade = topscore and topscore:GetGrade() or 'Grade_NoData'
						score = topscore and topscore:GetPercentDP() or 0;
						score = FormatPercentScore(score)
					end
				else
					grade = 'Grade_NoData'
					score = FormatPercentScore(0)
				end
			else
				gradeChild.GradeIcon:visible(false)
				gradeChild.ScoreText:visible(false)
			end
			gradeChild.GradeIcon:setstate( GetGradeFrame(grade) )
			gradeChild.ScoreText:settext( score )
		end;
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		CurrentTrailP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
		CurrentTrailP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;

		LoadActor(THEME:GetPathG("_selmusic","grades"))..{
			Name="GradeIcon";
			InitCommand=cmd(y,-12;pause;);
			OnCommand=cmd(diffusealpha,0;sleep,0.6;linear,0.15;diffusealpha,1);
		};
		LoadFont("_smallcaps 8px")..{
			Name="ScoreText";
			InitCommand=cmd(x,20;y,4;halign,1;shadowlength,1;);
			OnCommand=cmd(diffusealpha,0;sleep,0.6;linear,0.15;diffusealpha,1);
		};
	};
};